<?php

class ControladorServicios{


	/*=============================================
	CREAR SERVICIOS
	=============================================*/

	static public function ctrCrearServicio(){

		if(isset($_POST["nuevoNombreServicio"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoNombreServicio"]) &&
			   preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoTipoServicio"])){

			   	$tabla = "tipo_servicios";

			   	$datos = array("nombre"=>$_POST["nuevoNombreServicio"],
					           "descripcion"=>$_POST["nuevoTipoServicio"],
					           "cantidad_bolsa"=>$_POST["nuevoCatidadBolsas"],
					           "valor_servicio"=>$_POST["nuevoValorServicio"]);

			   	$respuesta = ModeloServicios::mdlIngresarServicio($tabla, $datos);

			   	if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "El servicio ha sido guardado correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "servicios";

									}
								})

					</script>';

				}

			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El servicio no puede ir vacío o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "servicios";

							}
						})

			  	</script>';



			}

		}

	}

	/*=============================================
	MOSTRAR SERVICIOS
	=============================================*/

	static public function ctrMostrarServicios($item, $valor, $estado = null){

		$tabla = "tipo_servicios";

			$respuesta = ModeloServicios::mdlMostrarServicios($tabla, $item, $valor, $estado);

		return $respuesta;

	}

	static public function ctrMostrarContratosServicios($item, $valor,$valor2,$valor3){

		$tabla = "persona_servicio";

		$respuesta = ModeloServicios::mdlMostrarContratosServicios($tabla, $item, $valor,$valor2,$valor3);

		return $respuesta;

	}
	//aqui para ver el reporte de bloques
	static public function ctrMostrarporBloques($item,$valor,$valor2,$valor3){

		$tabla = "general_recuperacion";

		$respuesta = ModeloServicios::mdlMostrarporBloques($tabla, $item, $valor,$valor2,$valor3);

		return $respuesta;

	}
	//aqui para ver el reporte de detalle general para contabilidad
	static public function ctrMostrarporConta($item,$valor,$valor2,$valor3){

		$tabla = "concentrado_contabilidad";

		$respuesta = ModeloServicios::mdlMostrarporConta($tabla, $item, $valor,$valor2,$valor3);

		return $respuesta;

	}
	
	//aqui para ver el reporte de  general
	static public function ctrMostrarporGeneral($item,$valor,$valor2,$valor3){

		$tabla = "detalle_pagos";

		$respuesta = ModeloServicios::mdlMostrarporGeneral($tabla, $item, $valor,$valor2,$valor3);

		return $respuesta;

	}

	

	static public function ctrMostrarServiciosPersona($item, $valor){

		$tabla = "servicios";

		$respuesta = ModeloServicios::mdlMostrarServiciosPersona($tabla, $item, $valor);

		return $respuesta;

	}



	/*=============================================
	EDITAR SERVICIOS
	=============================================*/

	static public function ctrEditarServicio(){



		if(isset($_POST["editarNombreServicio"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["editarNombreServicio"]) &&
			   preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["editarTipoServicio"])){

			   	$tabla = "tipo_servicios";

			   	$datos = array("idtipo_servicios"=>$_POST["idtipo_servicios"],
			   				   "nombre"=>$_POST["editarNombreServicio"],
					           "descripcion"=>$_POST["editarTipoServicio"],
					           "cantidad_bolsa"=>$_POST["editarCatidadBolsas"],
					           "valor_servicio"=>$_POST["editarValorServicio"]);

			   	$respuesta = ModeloServicios::mdlEditarServicio($tabla, $datos);

			   	if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "El servicio ha sido actualizado correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "servicios";

									}
								})

					</script>';

				}

			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El servicio no puede ir vacío o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "servicios";

							}
						})

			  	</script>';



			}

		}

	}

	/*=============================================
	ELIMINAR SERVICIOS
	=============================================*/

	static public function ctrEliminarServicio(){

		if(isset($_GET["idtipo_servicios"])){

			$tabla ="tipo_servicios";
			$datos = $_GET["idtipo_servicios"];

			$respuesta = ModeloServicios::mdlEliminarServicio($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

				swal({
					  type: "success",
					  title: "El servicio ha sido borrado correctamente",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar",
					  closeOnConfirm: false
					  }).then(function(result){
								if (result.value) {

								window.location = "servicios";

								}
							})

				</script>';

			}

		}

	}

}
